/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.enchant;

import com.lothrazar.cyclic.enchant.EnchantmentCyclic;
import com.lothrazar.cyclic.util.ParticleUtil;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class TravellerEnchant
extends EnchantmentCyclic {
    public static final List<String> PROTS = Arrays.asList("sting", DamageSource.f_19316_.f_19326_, DamageSource.f_19314_.f_19326_, DamageSource.f_19325_.f_19326_);
    public static final String ID = "traveler";
    public static ForgeConfigSpec.BooleanValue CFG;

    public TravellerEnchant(Enchantment.Rarity rarityIn, EnchantmentCategory typeIn, EquipmentSlot ... slots) {
        super(rarityIn, typeIn, slots);
        if (this.isEnabled()) {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
    }

    public boolean m_6594_() {
        return this.isEnabled() && super.m_6594_();
    }

    public boolean m_6592_() {
        return this.isEnabled() && super.m_6592_();
    }

    public boolean isAllowedOnBooks() {
        return this.isEnabled() && super.isAllowedOnBooks();
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return this.isEnabled() && super.canApplyAtEnchantingTable(stack);
    }

    public boolean m_6081_(ItemStack stack) {
        boolean yes = this.isEnabled() && stack.m_41720_() instanceof ArmorItem && ((ArmorItem)stack.m_41720_()).m_40402_() == EquipmentSlot.LEGS;
        return yes;
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)CFG.get();
    }

    public int m_6586_() {
        return 1;
    }

    @SubscribeEvent
    public void onEnderTeleportEvent(EntityTeleportEvent.EnderPearl event) {
        int level;
        if (!this.isEnabled()) {
            return;
        }
        if (event.getEntity() instanceof LivingEntity && (level = this.getCurrentArmorLevelSlot((LivingEntity)event.getEntity(), EquipmentSlot.LEGS)) > 0) {
            event.setAttackDamage(0.0f);
        }
    }

    @SubscribeEvent
    public void onEntityUpdate(LivingDamageEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        int level = this.getCurrentArmorLevelSlot(event.getEntityLiving(), EquipmentSlot.LEGS);
        if (level > 0 && PROTS.contains(event.getSource().f_19326_)) {
            event.setAmount(0.1f);
        }
        if (level > 0 && event.getSource() == DamageSource.f_19315_) {
            if (event.getEntityLiving().f_19789_ <= 8.0f) {
                event.setAmount(0.1f);
            } else if (event.getEntityLiving().m_6844_(EquipmentSlot.CHEST).m_41720_() instanceof ElytraItem && event.getAmount() > event.getEntityLiving().m_21223_() - 0.5f) {
                event.setAmount(event.getEntityLiving().m_21223_() - 1.0f);
                ParticleUtil.spawnParticle(event.getEntity().f_19853_, (ParticleOptions)ParticleTypes.f_123778_, event.getEntity().m_142538_(), 4);
            }
        }
    }
}

